/*
 * Decompiled with CFR 0.152.
 */
package itx.erp.contracts.task;

import itx.erp.contracts.task.ContractAlertMail;
import itx.erp.contracts.task.ContractRenewalTask;
import itx.erp.contracts.task.ContractTaskGenerator;
import itx.erp.helper.ErpConfig;
import java.util.Date;
import jtbcore.container.BeanEventListener;
import jtbcore.util.AppLogger;
import jtbcore.util.DateUtil;

public class ContractTaskExecuter
implements Runnable,
BeanEventListener {
    protected int lastRun = -1;
    protected ErpConfig appConfig;
    protected ContractRenewalTask contractRenewalTask;
    protected ContractTaskGenerator contractTaskGenerator;
    protected ContractAlertMail contractAlertMail;
    protected Boolean running = false;
    protected Thread executor = null;

    public ErpConfig getAppConfig() {
        return this.appConfig;
    }

    public void setAppConfig(ErpConfig appConfig) {
        this.appConfig = appConfig;
    }

    public ContractRenewalTask getContractRenewalTask() {
        return this.contractRenewalTask;
    }

    public void setContractRenewalTask(ContractRenewalTask contractRenewalTask) {
        this.contractRenewalTask = contractRenewalTask;
    }

    public ContractTaskGenerator getContractTaskGenerator() {
        return this.contractTaskGenerator;
    }

    public void setContractTaskGenerator(ContractTaskGenerator contractTaskGenerator) {
        this.contractTaskGenerator = contractTaskGenerator;
    }

    public ContractAlertMail getContractAlertMail() {
        return this.contractAlertMail;
    }

    public void setContractAlertMail(ContractAlertMail contractAlertMail) {
        this.contractAlertMail = contractAlertMail;
    }

    @Override
    public void init() {
        this.checkRun();
        this.executor = new Thread(){

            @Override
            public void run() {
                do {
                    try {
                        Thread.sleep(300000L);
                        ContractTaskExecuter.this.checkRun();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } while (!Thread.currentThread().isInterrupted());
            }
        };
        this.executor.start();
    }

    public synchronized void checkRun() {
        AppLogger.log("Checking contract renals & task");
        if (this.running.booleanValue()) {
            return;
        }
        this.lastRun = DateUtil.ymdNow();
        Thread t = new Thread(this);
        t.start();
    }

    @Override
    public void run() {
        this.running = true;
        try {
            AppLogger.log("Starting contractRenewalTask...");
            this.contractRenewalTask.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            AppLogger.log("Starting contractTaskGenerator...");
            this.contractTaskGenerator.run();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            Date d = new Date();
            if (d.getHours() >= 8 && d.getHours() <= 20) {
                AppLogger.log("Starting contractAlertMail...");
                this.contractAlertMail.handleDaily();
                this.contractAlertMail.handleWeekly();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        AppLogger.log("Executer done...");
        this.running = false;
    }
}

